<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo app('translator')->get('modules.order.kotTicket'); ?></title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #ffffff;
        }

        .kot-container {
            width: 100%;
            max-width: 80mm; /* Matches 3-inch thermal printer width */
            margin: 0 auto;
            padding: 6.35mm;
            border: 1px solid #000;
        }

        .header {
            text-align: center;
            margin-bottom: 5mm;
        }

        .header h2 {
            margin: 0;
            font-size: 5mm;
            font-weight: bold;
            text-transform: uppercase;
        }

        .header p {
            margin: 1mm 0;
            font-size: 4mm;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 5mm;
        }

        th, td {
            font-size: 4mm;
            padding: 2mm;
            text-align: left;
            border-bottom: 1px dashed #000;
        }

        th {
            font-weight: bold;
        }

        .footer {
            margin-top: 5mm;
            font-size: 4mm;
        }

        .footer p {
            margin: 1mm 0;
        }

        .footer p.italic {
            font-style: italic;
        }

        .modifiers {
            font-size: 10pt;
            color: #555;
        }

        @media print {
            body {
                background-color: #ffffff;
            }

            .kot-container {
                border: none;
                box-shadow: none;
            }
        }
    </style>
</head>
<body>
    <div class="kot-container">
        <!-- Header -->
        <div class="header">
            <h2><?php echo app('translator')->get('modules.order.kitchenOrderTicket'); ?></h2>
            <strong><?php echo app('translator')->get('modules.order.orderNumber'); ?> #<?php echo e($kot->order->order_number); ?></strong>
            <?php if($kot->order->table): ?>
            <p><?php echo app('translator')->get('modules.table.table'); ?> - <span class="text-skin-base font-bold"><?php echo e($kot->order->table->table_code); ?></span></p>
            <?php endif; ?>
            <p><?php echo app('translator')->get('app.date'); ?>: <span><?php echo e($kot->created_at->timezone(timezone())->format('d-m-Y')); ?></span></p>
            <p><?php echo app('translator')->get('app.time'); ?>: <span><?php echo e($kot->created_at->timezone(timezone())->format('h:i A')); ?></span></p>
        </div>

        <!-- Items -->
        <div>
            <table>
            <thead>
                <tr>
                <th><?php echo app('translator')->get('modules.menu.itemName'); ?></th>
                <th style="text-align: right;"><?php echo app('translator')->get('modules.order.qty'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $kot->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                <td>
                    <?php echo e($item->menuItem->item_name); ?>

                    <?php if(isset($item->menuItemVariation)): ?>
                        <br><small>(<?php echo e($item->menuItemVariation->variation); ?>)</small>
                    <?php endif; ?>
                    <?php $__currentLoopData = $item->modifierOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $modifier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="modifiers">• <?php echo e($modifier->name); ?></div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </td>

                <td style="text-align: right;"><?php echo e($item->quantity); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
            </table>
        </div>

        <!-- Footer -->

        <div class="footer">
            <?php if($kot->note): ?>
            <p><?php echo app('translator')->get('modules.order.specialInstructions'); ?>:</p>
            <p class="italic"><?php echo e($kot->note); ?></p>
            <?php endif; ?>

        </div>
    </div>

    <script>
        window.onload = function() {
            window.print();
        }
    </script>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\project\pos_dash\resources\views/pos/printKot.blade.php ENDPATH**/ ?>