<?php

namespace App\Http\Controllers;

use Easebuzz\PayWithEasebuzzLaravel\PayWithEasebuzzLib;
use App\Models\Module;
use App\Models\Package;
use App\Enums\PackageType;
use App\Livewire\LandingSite\FooterSetting;
use App\Models\Contact;
use App\Models\Order;
use App\Models\CustomMenu;
use App\Models\FrontDetail;
use App\Models\FrontFaq;
use App\Models\FrontFeature;
use App\Models\FrontReviewSetting;
use App\Models\LanguageSetting;
use App\Models\Restaurant;
use Froiden\Envato\Traits\AppBoot;
use Illuminate\Support\Facades\File;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

class HomeController extends Controller
{

    use AppBoot;

    public function landing()
    {

        if (global_setting()->disable_landing_site) {
            return view('auth.restaurant_register');
        }

        return view('auth.login');
        // $this->showInstall();

        // $global = global_setting();

        // if ($global->disable_landing_site && !request()->ajax()) {
        //     return redirect(route('login'));
        // }

        // if ($global->landing_site_type == 'custom') {
        //     return response(file_get_contents($global->landing_site_url));
        // }

        // $this->modules = Module::pluck('name')->toArray();
        // $this->PackageFeatures = Package::ADDITIONAL_FEATURES;

        // $AllModulesWithFeature = array_merge(
        //     $this->modules,
        //     $this->PackageFeatures
        // );

        // $packages = Package::with('modules')
        //     ->where('package_type', '!=', PackageType::DEFAULT)
        //     ->where('package_type', '!=', PackageType::TRIAL)
        //     ->where('is_private', false)
        //     ->orderBy('sort_order', 'asc')
        //     ->get();

        // $trialPackage = Package::where('package_type', PackageType::TRIAL)->first();
        // $customMenu = CustomMenu::all();

        // $monthlyPackages = Package::where('package_type', PackageType::STANDARD)->where('monthly_status', true)->where('is_private', false)->get();
        // $annualPackages = Package::where('package_type', PackageType::STANDARD)->where('annual_status', true)->where('is_private', false)->get();
        // $lifetimePackages = Package::where('package_type', PackageType::LIFETIME)->where('is_private', false)->get();
        // $language = request()->get('lang', app()->getLocale());

        // $languageSetting = LanguageSetting::where('language_code', $language)->first();
        // $languageId = $languageSetting ? $languageSetting->id : null;
        // $frontDetails = FrontDetail::where('language_setting_id', $languageId)->first();
        // $frontFeatures = FrontFeature::where('language_setting_id', $languageId)->get();
        // $frontReviews = FrontReviewSetting::where('language_setting_id', $languageId)->get();
        // $frontFaqs = FrontFaq::where('language_setting_id', $languageId)->get();
        // $frontContact = Contact::where('language_setting_id', $languageId)->first();

        // if($global->landing_type == 'static'){
        //     return view('landing.index', compact('packages', 'AllModulesWithFeature', 'trialPackage', 'monthlyPackages', 'annualPackages', 'lifetimePackages'));

        // }else {
        //     return view('landing.dynamic-index', compact('packages', 'AllModulesWithFeature', 'trialPackage', 'monthlyPackages', 'annualPackages', 'lifetimePackages', 'customMenu','frontDetails','frontFeatures','frontReviews','frontFaqs','frontContact'));

        // }

    }

    public function signup()
    {
        if (global_setting()->disable_landing_site) {
            return view('auth.restaurant_register');
        }

        return view('auth.restaurant_signup');
    }

    public function customerLogout()
    {
        session()->flush();
        return redirect('/');
    }

    public function PaymentEaseBuzz(Request $request)
    {
        // dd($request->all());

        $order_Details = Order::where('id', $request->order_id)->first();

        // $txnid = uniqid("EBZ");
        // $data = [
        //     'txnid' => $txnid,
        //     'amount' => '100.00',
        //     'productinfo' => 'Coffee',
        //     'firstname' => 'John',
        //     'email' => 'john@example.com',
        //     'phone' => '9876543210',
        //     'surl' => url('/payment/success'),
        //     'furl' => url('/payment/failure'),
        // ];

        // // $param = $request->all();
        // $key = config('services.easebuzz.key');
        // $salt = config('services.easebuzz.salt');
        // $env = config('services.easebuzz.env');

        // $payebz = new PayWithEasebuzzLib($key, $salt, $env);
        // $result = $payebz->initiatePaymentAPI($data, true);

        $MERCHANT_KEY = config('services.easebuzz.key');
        $SALT = config('services.easebuzz.salt');
        $ENV = config('services.easebuzz.env'); // "test" or "prod"

        $easebuzzObj = new PayWithEasebuzzLib($MERCHANT_KEY, $SALT, $ENV);

        $postData = [
            'txnid' => uniqid('EBZ'),
            'amount' => '1.00',
            'firstname' => 'John',
            'email' => 'john@example.com',
            'phone' => '9876543210',
            'productinfo' => 'Coffee',
            'surl' => route('payment.success'),
            'furl' => route('payment.failure'),
        ];

        // dd($postData);

        $easebuzzObj->initiatePaymentAPI($postData);

    }

    public function manifest()
    {
        $hash = request()->query('hash', '');

        if(!empty($hash)){
             $slug = 'restaurant/' . $hash . '/';
        }else {
             $slug = 'super-admin/';
        }

        $relativeUrl = urldecode(request()->query('url', ''));

        $firstimagePath = public_path('user-uploads/favicons/' . $slug . 'android-chrome-192x192.png');
        $secondimagePath = public_path('user-uploads/favicons/' . $slug . 'android-chrome-512x512.png');
        $firsticonUrl = File::exists($firstimagePath) ? asset('user-uploads/favicons/' . $slug . 'android-chrome-192x192.png') : asset('img/192x192.png');
        $secondiconUrl = File::exists($secondimagePath) ? asset('user-uploads/favicons/' . $slug . 'android-chrome-512x512.png') : asset('img/512x512.png');
        $globalSetting = global_setting();

        $restaurant = Restaurant::where('hash', $hash)->first();
        return response()->json([
            'name' => $restaurant ? $restaurant->name : $globalSetting->name,
            'short_name' => $restaurant ? $restaurant->name : $globalSetting->name,
            'description' => $restaurant ? $restaurant->name : $globalSetting->name,
            'start_url' => url($relativeUrl),
            'display' => 'standalone',
            'background_color' => '#ffffff',
            'theme_color' => '#000000',
            'icons' => [
                [
                    'src' => $firsticonUrl,
                    'sizes' => '192x192',
                    'type' => 'image/png'
                ],
                [
                    'src' => $secondiconUrl,
                    'sizes' => '512x512',
                    'type' => 'image/png'
                ]
            ]
        ]);
    }

}
