<?php

namespace App\Helpers;

class EasebuzzHelper
{
    public static function initiate($data)
    {
        $key = config('services.easebuzz.key');
        $salt = config('services.easebuzz.salt');
        $env  = config('services.easebuzz.env');

        $txnid = $data['txnid'];
        $amount = $data['amount'];
        $productinfo = $data['productinfo'];
        $firstname = $data['firstname'];
        $email = $data['email'];

        $hashSequence = "$key|$txnid|$amount|$productinfo|$firstname|$email|||||||||||$salt";
        $hash = hash("sha512", $hashSequence);

        $action_url = $env === 'prod'
            ? 'https://pay.easebuzz.in/pay/'
            : 'https://testpay.easebuzz.in/pay/';

        return [
            'url' => $action_url,
            'data' => [
                'key' => $key,
                'txnid' => $txnid,
                'amount' => $amount,
                'productinfo' => $productinfo,
                'firstname' => $firstname,
                'email' => $email,
                'phone' => $data['phone'],
                'surl' => $data['surl'],
                'furl' => $data['furl'],
                'hash' => $hash,
            ]
        ];
    }
}
